#include <system.h>
#include <usb.h>
#include <usb_device_hid.h>

extern unsigned char OUT_Buffer[64] @ HID_CUSTOM_OUT_DATA_BUFFER_ADDRESS;
extern unsigned char IN_Buffer[64] @ HID_CUSTOM_IN_DATA_BUFFER_ADDRESS;
char settings[32];
extern char display_data[512];
extern uint8_t text_lenght;
extern volatile USB_HANDLE USBOutHandle;    
extern volatile USB_HANDLE USBInHandle;
extern LCD_CONFIGURATION LcdConfig;
extern uint8_t delay;

void FlashToRam(void)
{
    FlashRead(&display_data, 0x1E00, 512);
    
    for(uint8_t i = 0; i < 16; i++)
    {
        if(display_data[i] != 0x00 && display_data[i] != 0xFF)
            text_lenght++;
    } 
    FlashRead(&settings, 0x1DE0, 32);
    if(settings[0] != 0xFF)
    {
        delay = settings[1];
        LcdConfig.BACKLIGHT = settings[2];
    }
    else
    {
        LcdConfig.BACKLIGHT = 0;
    }
}


void FlashUnlock(void)
{
    PMCON2 = 0x55;
    PMCON2 = 0xAA;
    PMCON1bits.WR = 1;
    NOP();
    NOP();
}

void FlashErase(unsigned int addr, unsigned  int lenght)
{
    unsigned char i = 0;
 
    INTCONbits.GIE = 0;
    
    PMADRL = addr & 0xFF;
    PMADRH = (addr & 0xFF00) >> 8;
    
    PMCON1bits.CFGS = 0;
    PMCON1bits.FREE = 1;
    PMCON1bits.WREN = 1;
    
    if(lenght < 32)
    {
        lenght = 1;
    }
    else
    {
        lenght /= 32;
    }
    
    for(i = 0; i < lenght; i++ )
    {
        PMCON1bits.FREE = 1;
        FlashUnlock();
        PMADRL += 0x20;
        if(PMADRL == 0) PMADRH ++;
    }
    PMCON1bits.WREN = 0;
    INTCONbits.GIE = 1;
}

void FlashWrite(unsigned char* data, unsigned int addr, unsigned int lenght)
{
    unsigned char i = 0;
    
    INTCONbits.GIE = 0;
    
    PMADRL = addr & 0xFF;
    PMADRH = (addr & 0xFF00) >> 8;
    
    PMCON1bits.CFGS = 0;
    PMCON1bits.WREN = 1;
    if(lenght < 32)
    {
        lenght = 1;
    }
    else
    {
        lenght /= 32;
    }
    
    for(i = 0; i < lenght; i++)
    {
        PMCON1bits.LWLO = 1;
        while(1)
        {
            PMDATL = *data++;
            PMDATH = 0x34;
            if(((PMADRL ^ 0x1F) & 0x1F) == 0) break;
            FlashUnlock();
            PMADRL++;
        }
        PMCON1bits.LWLO = 0;
        FlashUnlock();
        PMADRL++;
        if(PMADRL == 0)PMADRH ++;
    }
    PMCON1bits.WREN = 0;
    INTCONbits.GIE = 1;
}

void FlashRead(unsigned char *flash_data, unsigned int addr, unsigned int lenght)
{
    unsigned int i = 0;
    
    INTCONbits.GIE = 0;
    
    PMADRL = addr & 0xFF;
    PMADRH = (addr & 0xFF00) >> 8;
    PMCON1bits.CFGS = 0;
    
    for(i = 0; i < lenght; i++)
    {
        PMCON1bits.RD = 1;
        NOP();
        NOP();
        *flash_data++ = PMDATL;
        PMADRL++;
        if(PMADRL == 0)PMADRH ++;
    }
    INTCONbits.GIE = 1;
}
